####### Parameter ################
seed<-1
repeat_num<-100
iteration_num<-200

threshold_theta<- 0
kernel_var<-4
kernel_length<-25
noise_var<-10^(-6)

fixed_straddle_beta<-3
theoretical_straddle_delta<-0.05
MILE_beta<-3
AF_num<- 1			#1: random, 2: US, 3: MILE, 4: Straddle, 5: LSE, 6: Proposed
##################################

####### True function ############
True_function_val<- (read.table("Dataset-Target-E6.txt")[,3]-3)*(-1)
##################################

####### Input ####################

ALL_X<- as.matrix(read.table("Dataset-Target-E6.txt")[,1:2])
##################################

####### Function ############
compute_kernel<-function(x1,x2)
{
r<-sqrt(sum((x1-x2)^2))
kernel_var*(1+sqrt(3)*r/kernel_length)*exp(-sqrt(3)*r/kernel_length)

}

compute_kernel2<-function(x)
{
n1<- length(x)/2
n2<- length(x)
r<- sqrt(sum(   (x[1:n1]-x[(n1+1):n2])^2     ))
kernel_var*(1+sqrt(3)*r/kernel_length)*exp(-sqrt(3)*r/kernel_length)
}


compute_pre<-function(true,est)
{
	if(length(est)==0)
	{
		if(length(true)==0)
		{
		a<-1
		} else {
		a<-0
		}
	} else {
	a<- length(intersect(true,est))/length(est)
	}
a
}

compute_rec<-function(true,est)
{
	if(length(true)==0)
	{
	a<-1	
	} else {
	a<- length(intersect(true,est))/length(true)
	}
a
}

compute_Fscore<-function(pre,rec)
{
	if((pre+rec)==0)
	{
	a<-0	
	} else {
	a<- 2*pre*rec/(pre+rec)
	}
a
}

compute_acc<-function(true_H,true_L,est_H,est_L)
{
	(length(intersect(true_H,est_H)) + length(intersect(true_L,est_L)))/(length(true_H) + length(true_L))
}

##################################

####### Prior cov ################
if(AF_num==3)
{
prior_cov<- diag(length(ALL_X[,1]))
	for(i in 1:length(ALL_X[,1]))
	{
		prior_cov[i,]<- apply(cbind(rbind(ALL_X[i,])%x%rep(1,length(ALL_X[,1])),rbind(ALL_X)),1,compute_kernel2)
	
	}
}
##################################

####### result mat ###############
result_mat_pre<- matrix(numeric(repeat_num*iteration_num),repeat_num,iteration_num)
result_mat_rec<- matrix(numeric(repeat_num*iteration_num),repeat_num,iteration_num)
result_mat_F<- matrix(numeric(repeat_num*iteration_num),repeat_num,iteration_num)
result_mat_acc<- matrix(numeric(repeat_num*iteration_num),repeat_num,iteration_num)
result_mat_loss<- matrix(numeric(repeat_num*iteration_num),repeat_num,iteration_num)
result_mat_meanloss<- matrix(numeric(repeat_num*iteration_num),repeat_num,iteration_num)
##################################


##################################
##################################
##################################
########### OPTIMIZE #############
##################################
##################################
##################################
for(w in 1:repeat_num)
{
set.seed((seed-1)*repeat_num+w)
true_function<- True_function_val
trueH<- c(1:length(ALL_X[,1]))[true_function>=threshold_theta]
trueL<-  setdiff(c(1:length(ALL_X[,1])),trueH)

k_vec_mat<- ALL_X[,1]%x%t(numeric(iteration_num))

X<-c()
Y<-c()
x_num<-c()
new_x_num<- sample(c(1:length(ALL_X[,1])),1)
new_x<- ALL_X[new_x_num,]
new_y<- true_function[new_x_num] #+ rnorm(1,0,sqrt(noise_var))


LSE_u<- numeric(length(ALL_X[,1]))+sqrt(2*log(length(ALL_X[,1])*pi^2*1^2/(6*theoretical_straddle_delta)))*sqrt(kernel_var)
LSE_l<- numeric(length(ALL_X[,1]))-sqrt(2*log(length(ALL_X[,1])*pi^2*1^2/(6*theoretical_straddle_delta)))*sqrt(kernel_var)



	for(ww in 1:iteration_num)
	{
	X<-rbind(X,new_x)
	Y<-c(Y,new_y)
	x_num<-c(x_num,new_x_num)

	k_vec_mat[,ww]<-  apply(cbind(ALL_X,t(new_x)%x%rep(1,length(ALL_X[,1]))),1,compute_kernel2)
	K<-as.matrix(k_vec_mat[x_num,1:ww])
	C<- K+ noise_var*diag(ww)
	Cinv<- solve(C)

	post_mean<- as.vector(cbind(k_vec_mat[,1:ww])%*%Cinv%*%Y) 
	post_var<- abs(kernel_var-rowSums((cbind(k_vec_mat[,1:ww])%*%Cinv)*cbind(k_vec_mat[,1:ww])))

	estH<- c(1:length(ALL_X[,1]))[post_mean>=threshold_theta]
	estL<-  setdiff(c(1:length(ALL_X[,1])),estH)

	result_mat_pre[w,ww]<-compute_pre(trueH,estH)
	result_mat_rec[w,ww]<-compute_rec(trueH,estH)
	result_mat_F[w,ww]<-compute_Fscore(result_mat_pre[w,ww],result_mat_rec[w,ww])
	result_mat_acc[w,ww]<-compute_acc(trueH,trueL,estH,estL)
	
	no_H_num<- intersect(trueH,estL)
	no_L_num<- intersect(trueL,estH)
		if(  length(c(no_H_num,no_L_num) )==0  )
		{
		result_mat_loss[w,ww]<-0
		result_mat_meanloss[w,ww]<-0
		} else {
		result_mat_loss[w,ww]<-max(abs(true_function[c(no_H_num,no_L_num)]-threshold_theta))
		result_mat_meanloss[w,ww]<-sum(abs(true_function[c(no_H_num,no_L_num)]-threshold_theta))/(length(ALL_X[,1]))
		}
	########################## acquisition function ###################################
		if(AF_num==1)
		{
			new_x_num<- sample(setdiff(c(1:length(ALL_X[,1])),x_num),1)
			
		}

		if(AF_num==2)
		{
			post_var2<-post_var
			post_var2[sort(unique(x_num))]<- -10^10
			new_x_num<- order(post_var2,decreasing=T)[1]
		}

		if(AF_num==3)
		{
			post_cov<-prior_cov-cbind(k_vec_mat[,1:ww])%*%Cinv%*%t(cbind(k_vec_mat[,1:ww]))
			post_var_add_mat<-post_var%x%t(rep(1,length(ALL_X[,1])))-(post_cov)^2 * t(1/( post_var+noise_var ))%x%rep(1,length(ALL_X[,1]))
			add_H<-post_mean%x%t(rep(1,length(ALL_X[,1])))-MILE_beta*sqrt(post_var_add_mat)-threshold_theta
			#add_L<- -post_mean%x%t(rep(1,length(ALL_X[,1])))-MILE_beta*sqrt(post_var_add_mat)+threshold_theta
			MILE_stand<-t(sqrt(post_var+noise_var))%x%rep(1,length(ALL_X[,1]))/abs(post_cov)
			AFx<-colSums(pnorm(MILE_stand*add_H)) #+pnorm(MILE_stand*add_L)
			
			AFx2<-AFx
			AFx2[sort(unique(x_num))]<- -10^10
			new_x_num<- order(AFx2,decreasing=T)[1]
		}
		
		if(AF_num==4)
		{
			ucb<-post_mean+fixed_straddle_beta*sqrt(post_var)
			lcb<-post_mean-fixed_straddle_beta*sqrt(post_var)
			AFx<-apply(cbind(ucb-threshold_theta,threshold_theta-lcb),1,min)
			AFx2<-AFx
			AFx2[sort(unique(x_num))]<- -10^10
			new_x_num<- order(AFx2,decreasing=T)[1]
		}

		if(AF_num==5)
		{
			theoretical_straddle_beta<- sqrt(2*log(length(ALL_X[,1])*pi^2*ww^2/(6*theoretical_straddle_delta)))
			ucb<-post_mean+theoretical_straddle_beta*sqrt(post_var)
			lcb<-post_mean-theoretical_straddle_beta*sqrt(post_var)

			LSE_u<- apply(cbind(LSE_u,ucb),1,min)
			LSE_l<- apply(cbind(LSE_l,lcb),1,max)
			check_0_1<- (LSE_u>=LSE_l)*1
			LSE_u<- LSE_u*check_0_1+(1-check_0_1)*ucb
			LSE_l<- LSE_l*check_0_1+(1-check_0_1)*lcb


			AFx<-apply(cbind(LSE_u-threshold_theta,threshold_theta-LSE_l),1,min)
			AFx2<-AFx
			AFx2[sort(unique(x_num))]<- -10^10
			new_x_num<- order(AFx2,decreasing=T)[1]
		}

		if(AF_num==6)
		{
			r_straddle_beta<- sqrt(rexp(1,0.5))
			ucb<-post_mean+r_straddle_beta*sqrt(post_var)
			lcb<-post_mean-r_straddle_beta*sqrt(post_var)
			AFx<-apply(cbind(ucb-threshold_theta,threshold_theta-lcb),1,min)
			AFx2<-AFx
			AFx2[sort(unique(x_num))]<- -10^10
			new_x_num<- order(AFx2,decreasing=T)[1]
		}

		

		

	###################################################################################
	
	new_x<- ALL_X[new_x_num,]
	new_y<- true_function[new_x_num] #+ rnorm(1,0,sqrt(noise_var))


	}

}



write.table(result_mat_pre,"result_mat_pre.txt")
write.table(result_mat_rec,"result_mat_rec.txt")
write.table(result_mat_F,"result_mat_F.txt")
write.table(result_mat_acc,"result_mat_acc.txt")
write.table(result_mat_loss,"result_mat_loss.txt")
write.table(result_mat_meanloss,"result_mat_meanloss.txt")


